from rest_framework.response import Response
from rest_framework.decorators import api_view
from base.models import Item
from .serializers import ItemSerializer

import snscrape.modules.twitter as sntwitter

@api_view(['GET'])
def getData(request):
	items = Item.objects.all()
	serializer = ItemSerializer(items, many=True)
	return Response(serializer.data)

@api_view(['POST'])
def addItem(request):
	serializer = ItemSerializer(data=request.data)
	if serializer.is_valid():
		serializer.save()
	return Response(serializer.data)

@api_view(['GET'])
def twitterData(request):
	scraper = sntwitter.TwitterSearchScraper("#python")
	tweets = []
	n_tweets = 1_000

	for i, tweet in enumerate(scraper.get_items()):
	    date = [
	        tweet.id,
	        tweet.date,
	        tweet.content,
	        tweet.user.username,
	        tweet.likeCount,
	        tweet.retweetCount
	    ]
	    tweets.append(data)
	    if i > n_tweets:
	        break

	return Response(serializer.tweets)






# import twint
# import nest_asyncio
# nest_asyncio.apply()

# import twint
# config = twint.Config()
# # config.Proxy_host = "127.0.0.1"
# # config.Proxy_port = "4219"
# # config.Proxy_type = "http"


# # Configure
# config.username = "nasaspaceflight"
# config.Search = "raptor"
# config.limit = 10
# # Run
# twint.run.Search(config)